//-----------------------------------------------------------------------------
// Torque Engine
// 
// Copyright (C) GarageGames.com, Inc.
//-----------------------------------------------------------------------------

function OpenALInit()
{
   OpenALShutdownDriver();

   echo("");
   echo("OpenAL Driver Init:");

   echo ($pref::Audio::driver);

   if($pref::Audio::driver $= "OpenAL")
   {
      if(!OpenALInitDriver())
      {
         error("   Failed to initialize driver.");
         $Audio::initFailed = true;
      } else {
         // this should go here
         echo("   Vendor: " @ alGetString("AL_VENDOR"));
         echo("   Version: " @ alGetString("AL_VERSION"));  
         echo("   Renderer: " @ alGetString("AL_RENDERER"));
         echo("   Extensions: " @ alGetString("AL_EXTENSIONS"));

         alxListenerf( AL_GAIN_LINEAR, $pref::Audio::masterVolume );
   
         for (%channel=1; %channel <= 8; %channel++)
            alxSetChannelVolume(%channel, $pref::Audio::channelVolume[%channel]);

         echo("");
      }
   }

}


//--------------------------------------------------------------------------

function OpenALShutdown()
{
   OpenALShutdownDriver();
   //alxStopAll();
   //AudioGui.delete();
   //sButtonDown.delete();
   //sButtonOver.delete();
}

function muteSound(%mute)
{
   // Channel one and two muted normally
   if(%mute) {
      alxSetChannelVolume(1, 0);
      alxSetChannelVolume(2, 0);
   }
   else {
      alxSetChannelVolume(1, $pref::Audio::channelVolume1);
      alxSetChannelVolume(2, $pref::Audio::channelVolume2);
   }
   
   // The rest of the channels are muted only if in the menu (taken care of
   // by in game menu when playing game)
   if(!$PlayingGame) {   
      for(%channel = 3; %channel <= 8; %channel++) {
         if(%mute) {
            alxSetChannelVolume(%channel, 0);
         }
         else {
            alxSetChannelVolume(%channel, $pref::Audio::channelVolume[%channel]);
         }
      }
   }
}

function muteSoundFX(%mute)
{
   // Mute all sound fx except for UI (channel 2)
   for(%channel = 3; %channel <= 8; %channel++) {
      if(%mute) {
         alxSetChannelVolume(%channel, 0);
      }
      else {
         alxSetChannelVolume(%channel, $pref::Audio::channelVolume[%channel]);
      }
   }
}